/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.container.AmmoBenchContainer;
import dev.toma.gunsrpg.common.tileentity.AmmoBenchTileEntity;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_AmmoBenchEventPacket;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchRecipe;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AmmoBenchScreen
extends ContainerScreen<AmmoBenchContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = GunsRPG.makeResource("textures/screen/ammo_bench.png");
    private static final ITextComponent CRAFT_LABEL = new TranslationTextComponent("screen.ammo_bench.label.craft");
    private static final ITextComponent NONE_LABEL = new TranslationTextComponent("screen.ammo_bench.label.none_selected");
    private static final String SELECTED_RECIPE_LABEL_KEY = "screen.ammo_bench.label.selected_recipe";
    private Button craftButton;
    private Button nextRecipeButton;
    private Button previousRecipeButton;

    public AmmoBenchScreen(AmmoBenchContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = 175;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.craftButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 61, this.field_147009_r + 69, 54, 20, CRAFT_LABEL, this::craftButtonClicked));
        this.craftButton.field_230693_o_ = false;
        this.previousRecipeButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 38, this.field_147009_r + 69, 20, 20, (ITextComponent)new StringTextComponent("<"), this::previousRecipeButtonClicked));
        this.previousRecipeButton.field_230693_o_ = false;
        this.nextRecipeButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 118, this.field_147009_r + 69, 20, 20, (ITextComponent)new StringTextComponent(">"), this::nextRecipeButtonClicked));
        this.nextRecipeButton.field_230693_o_ = false;
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        AmmoBenchTileEntity tileEntity = (AmmoBenchTileEntity)((Object)((AmmoBenchContainer)this.field_147002_h).getTileEntity());
        if (tileEntity.isCrafting()) {
            float progress = tileEntity.getCraftingProgress();
            this.func_238474_b_(matrix, this.field_147003_i + 75, this.field_147009_r + 43, 176, 0, (int)(26.0f * progress) + 1, 12);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
        AmmoBenchRecipe recipe = ((AmmoBenchTileEntity)((Object)((AmmoBenchContainer)this.field_147002_h).getTileEntity())).getActiveRecipe();
        matrix.func_227860_a_();
        float textScale = 0.8f;
        matrix.func_227862_a_(textScale, textScale, textScale);
        ITextComponent recipeLabel = recipe != null ? new TranslationTextComponent("recipe." + recipe.func_199560_c().toString().replaceAll("[:/]", ".")) : NONE_LABEL;
        TranslationTextComponent selectedRecipeLabel = new TranslationTextComponent(SELECTED_RECIPE_LABEL_KEY, new Object[]{recipeLabel});
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)selectedRecipeLabel, (float)(this.field_238742_p_ + 1), (float)(this.field_238743_q_ + 12), 0x404040);
        matrix.func_227865_b_();
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    public void func_231023_e_() {
        this.updateButtonStates();
        super.func_231023_e_();
    }

    private void craftButtonClicked(Button button) {
        NetworkManager.sendServerPacket(C2S_AmmoBenchEventPacket.craftingEvent(this.getPositionForNetworking()));
    }

    private void nextRecipeButtonClicked(Button button) {
        NetworkManager.sendServerPacket(C2S_AmmoBenchEventPacket.nextRecipe(this.getPositionForNetworking()));
    }

    private void previousRecipeButtonClicked(Button button) {
        NetworkManager.sendServerPacket(C2S_AmmoBenchEventPacket.previousRecipe(this.getPositionForNetworking()));
    }

    private void updateButtonStates() {
        AmmoBenchTileEntity tileEntity = (AmmoBenchTileEntity)((Object)((AmmoBenchContainer)this.field_147002_h).getTileEntity());
        AmmoBenchRecipe recipe = tileEntity.getActiveRecipe();
        if (recipe == null) {
            this.craftButton.field_230693_o_ = false;
            this.previousRecipeButton.field_230693_o_ = false;
            this.nextRecipeButton.field_230693_o_ = false;
        } else {
            this.craftButton.field_230693_o_ = !tileEntity.isCrafting() && tileEntity.canCraftCurrentRecipe((PlayerEntity)this.field_230706_i_.field_71439_g);
            this.previousRecipeButton.field_230693_o_ = tileEntity.canSelectPreviousRecipe();
            this.nextRecipeButton.field_230693_o_ = tileEntity.canSelectNextRecipe();
        }
    }

    private BlockPos getPositionForNetworking() {
        return ((AmmoBenchTileEntity)((Object)((AmmoBenchContainer)this.field_147002_h).getTileEntity())).func_174877_v();
    }
}

